<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 *
 * Let's Review internationalization Class
 *
 * @since      1.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/includes
 */

class Lets_Review_i18n {

	/**
     * Var for URL.
     *
     * @since    2.0.0
     */
    private $dir_path;

    /**
     * Admin Constructor
     *
     * @since 2.0.0
     *
    */
    public function __construct( $dir_path ) {

        $this->dir_path = $dir_path;

    }

	/**
	 * Let's Review Translation
	 *
	 * @since    1.0.0
	 */
	public function lets_review_textdomain() {

		load_plugin_textdomain( 'lets-review', false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');

	}

	/**
	 * i18n
	 *
	 * @since    1.0.0
	 */
	public function lets_review_i18n_button( $i18n ) {

		$i18n[] = $this->dir_path . 'admin/lets-review-i18n-strings.php';
    	return $i18n;

	}

}